﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <nn/fs/fs_SystemSaveData.h>
#include <nn/fs/fs_SaveDataManagement.h>

namespace nn { namespace ncm {
    const fs::SystemSaveDataId  BuildInSystemSystemSaveDataId           = 0x8000000000000120;
    const fs::SystemSaveDataId  BuildInUserSystemSaveDataId             = 0x8000000000000121;
    const fs::SystemSaveDataId  SdCardSystemSaveDataId                  = 0x8000000000000124;

    const int64_t               BuildInSystemSystemSaveDataSize         = 0x6C000; // 400 KB + 32 KB
    const int64_t               BuildInUserSystemSaveDataSize           = 0x29E000; // 2.6 MB + 32 KB
    const int64_t               SdCardSystemSaveDataSize                = 0xA08000; // 10 MB + 32 KB

    const int64_t               BuildInSystemSystemSaveDataJournalSize  = 0x6C000; // 400 KB + 32 KB
    const int64_t               BuildInUserSystemSaveDataJournalSize    = 0x29E000; // 2.6 MB + 32 KB
    const int64_t               SdCardSystemSaveDataJournalSize         = 0xA08000; // 10 MB + 32 KB

    const int                   BuildInSystemSystemSaveDataFlag         = fs::SaveDataFlags_KeepAfterResettingSystemSaveData | fs::SaveDataFlags_KeepAfterRefurbishment;
    const int                   BuildInUserSystemSaveDataFlag           = 0;
    const int                   SdCardSystemSaveDataFlag                = 0;
}}
