﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/ncm/ncm_ContentMetaKey.h>

namespace nn { namespace ncm {
    const int64_t MaxClusterSize = 256 * 1024;

    int64_t CalculateRequiredSize(int64_t fileSize, int64_t clusterSize = MaxClusterSize) NN_NOEXCEPT;

    int64_t CalculateRequiredSizeForExtension(int64_t fileSize, int64_t clusterSize = MaxClusterSize) NN_NOEXCEPT;

    // ncm_ContentMeta.h でこのファイルを include しているため、相互参照になってしまう
    // そのため、前方宣言を利用する

    class ContentMetaDatabase;
    Result EstimateRequiredSize(int64_t* outValue, const ContentMetaKey& key, const ContentMetaDatabase* pDb) NN_NOEXCEPT;
}}
