﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/ncm/ncm_StorageId.h>

#include <nn/lr/lr_LocationResolver.h>
#include <nn/lr/lr_RegisteredLocationResolver.h>
#include <nn/lr/lr_AddOnContentLocationResolver.h>

namespace nn { namespace lr {

    /**
    * @brief lr サービスに必要なリソースを初期化します。
    */
    void Initialize() NN_NOEXCEPT;

    /**
    * @brief lr サービスに必要なリソースを開放します。
    */
    void Finalize() NN_NOEXCEPT;

    /**
    * @brief    指定された名前の LocationReslver を取得します。
    *
    * @param[out]   outValue    LocationResolver を取得するバッファ
    * @param[in]    storageId   LocationResolver が対象とするストレージ
    *
    * @return   処理の結果が返ります。
    * @retval   ResultUnknownResolver   未知のリゾルバが指定されました
    *
    * @pre
    *           - Initialize の成功
    */
    Result OpenLocationResolver(LocationResolver* outValue, ncm::StorageId storageId) NN_NOEXCEPT;

    /**
    * @brief    RegisteredLocationResolver を取得します
    *
    * @param[out]   outValue    LocationResolver を取得するバッファ
    *
    * @return   処理の結果が返ります。
    *
    * @pre
    *           - Initialize の成功
    */
    Result OpenRegisteredLocationResolver(RegisteredLocationResolver* outValue) NN_NOEXCEPT;

    /**
    * @brief    AddOnContentLocationResolver を取得します
    *
    * @param[out]   outValue    AddOnContentLocationResolver を取得するバッファ
    *
    * @return   処理の結果が返ります。
    *
    * @pre
    *           - Initialize の成功
    */
    Result OpenAddOnContentLocationResolver(AddOnContentLocationResolver* outValue) NN_NOEXCEPT;

    /**
    * @brief    指定されたストレージの LocationResolver を更新します。
    *
    * @param[in]    storageId   LocationResolver が対象とするストレージ
    *
    * @return   処理の結果が返ります。
    * @retval   ResultUnknownResolver   未知のリゾルバが指定されました
    *
    * @pre
    *           - Initialize の成功
    *           - storageId に対して OpenLocationResolver の呼び出しが成功している
    */
    Result RefreshLocationResolver(ncm::StorageId storageId) NN_NOEXCEPT;
}
}
