﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/lr/lr_Path.h>

namespace nn { namespace lr {

// 高々数個しか登録されない想定
template <typename IdType, typename DataType, int SIZE> class RegisteredData
{
private:
    struct LocationMap
    {
        DataType    data;
        IdType      id;
        bool        isValid;
    };
    LocationMap m_Maps[SIZE];

    NN_DISALLOW_COPY(RegisteredData);
    NN_DISALLOW_MOVE(RegisteredData);

public:
    RegisteredData() NN_NOEXCEPT
    {
        Clear();
    }
    bool Register(IdType id, DataType path) NN_NOEXCEPT
    {
        for (LocationMap& m : m_Maps)
        {
            if (m.isValid == false)
            {
                m.isValid = true;
                m.id = id;
                m.data = path;
                return true;
            }
        }
        return false;
    }
    bool Unregister(IdType id) NN_NOEXCEPT
    {
        for (LocationMap& m : m_Maps)
        {
            if (m.id == id)
            {
                m.isValid = false;
                return true;
            }
        }
        return false;
    }
    bool Find(DataType* outValue, IdType id) NN_NOEXCEPT
    {
        for (LocationMap& m : m_Maps)
        {
            if (m.isValid == true && m.id == id)
            {
                *outValue = m.data;
                return true;
            }
        }
        return false;
    }
    void Clear() NN_NOEXCEPT
    {
        for (LocationMap& m : m_Maps)
        {
            m.isValid = false;
        }
    }
};

template<typename T, int SIZE>
using RegisteredLocations = RegisteredData<T, lr::Path, SIZE>;

}}
