﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>

#include <nn/os/os_Mutex.h>
#include <nn/ncm/ncm_BoundedMap.h>
#include <nn/lr/lr_ILocationResolver.h>
#include <nn/lr/lr_ILocationResolverManager.h>

namespace nn { namespace lr {

    class LocationResolverManagerImpl
    {
        NN_DISALLOW_COPY(LocationResolverManagerImpl);
        NN_DISALLOW_MOVE(LocationResolverManagerImpl);

    public:
        LocationResolverManagerImpl() NN_NOEXCEPT: m_RegisteredLocationResolver(nullptr), m_Mutex(false){}

        Result OpenLocationResolver(sf::Out<sf::SharedPointer<ILocationResolver>> outValue, Bit8 storageId) NN_NOEXCEPT;
        Result OpenRegisteredLocationResolver(sf::Out<sf::SharedPointer<IRegisteredLocationResolver>> outValue) NN_NOEXCEPT;
        Result RefreshLocationResolver(Bit8 storageId) NN_NOEXCEPT;
        Result OpenAddOnContentLocationResolver(sf::Out<sf::SharedPointer<IAddOnContentLocationResolver>> outValue) NN_NOEXCEPT;

    private:
        ncm::BoundedMap<Bit8, sf::SharedPointer<ILocationResolver>, 5> m_LocationResolverMap;
        sf::SharedPointer<IRegisteredLocationResolver> m_RegisteredLocationResolver;
        sf::SharedPointer<IAddOnContentLocationResolver> m_AddOnContentLocationResolver;
        os::Mutex m_Mutex;
    };
}}
