﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/ncm/ncm_ContentMetaDatabase.h>
#include <nn/ncm/ncm_ContentStorage.h>
#include <nn/lr/lr_LocationRedirector.h>
#include <nn/lr/lr_ILocationResolver.h>

namespace nn { namespace lr {

        class ContentLocationResolverImpl
        {
        NN_DISALLOW_COPY(ContentLocationResolverImpl);
        NN_DISALLOW_MOVE(ContentLocationResolverImpl);

        public:
            explicit ContentLocationResolverImpl(ncm::StorageId storageId) NN_NOEXCEPT : m_StorageId(storageId) {}

            Result ResolveProgramPath(sf::Out<Path> outValue, ncm::ProgramId id) NN_NOEXCEPT;

            Result RedirectProgramPath(ncm::ProgramId id, const lr::Path& redirectedPath) NN_NOEXCEPT;

            Result RedirectApplicationProgramPath(ncm::ProgramId id, const lr::Path& redirectedPath) NN_NOEXCEPT;

            Result ResolveDataPath(sf::Out<lr::Path> outValue, ncm::DataId id) NN_NOEXCEPT;

            Result ResolveApplicationControlPath(sf::Out<lr::Path> outValue, ncm::ProgramId id) NN_NOEXCEPT;

            Result RedirectApplicationControlPath(ncm::ProgramId id, const lr::Path& redirectedPath) NN_NOEXCEPT;

            Result ResolveApplicationHtmlDocumentPath(sf::Out<lr::Path> outValue, ncm::ProgramId id) NN_NOEXCEPT;

            Result RedirectApplicationHtmlDocumentPath(ncm::ProgramId id, const lr::Path& redirectedPath) NN_NOEXCEPT;

            Result ResolveApplicationLegalInformationPath(sf::Out<lr::Path> outValue, ncm::ProgramId id) NN_NOEXCEPT;
            Result RedirectApplicationLegalInformationPath(ncm::ProgramId id, const lr::Path& redirectedPath) NN_NOEXCEPT;

            Result Refresh() NN_NOEXCEPT;

            Result ClearApplicationRedirection() NN_NOEXCEPT;

            Result EraseProgramRedirection(ncm::ProgramId programId) NN_NOEXCEPT;

            Result EraseApplicationControlRedirection(ncm::ProgramId programId) NN_NOEXCEPT;

            Result EraseApplicationHtmlDocumentRedirection(ncm::ProgramId programId) NN_NOEXCEPT;

            Result EraseApplicationLegalInformationRedirection(ncm::ProgramId programId) NN_NOEXCEPT;

        private:
            void GetContentPath(sf::Out<Path>* outValue, ncm::ContentId contentId) NN_NOEXCEPT;
            bool GetRedirectedPath(sf::Out<Path>* outValue, LocationRedirector* redirector, ncm::ProgramId id) NN_NOEXCEPT;
            void ClearRedirection(int flag) NN_NOEXCEPT;

            LocationRedirector m_ProgramRedirector;
            LocationRedirector m_ControlRedirector;
            LocationRedirector m_HtmlDocumentRedirector;
            LocationRedirector m_LegalInformationRedirector;

            ncm::StorageId m_StorageId;
            ncm::ContentMetaDatabase m_Meta;
            ncm::ContentStorage m_Storage;
        };
}}
