﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Result.h>
#include <nn/ldr/ldr_Types.h>
#include <nn/os/os_Types.h>
#include <nn/svc/svc_Types.h>
#include <nn/ncm/ncm_ProgramId.h>

namespace nn {
namespace ldr {

    namespace detail
    {
        const char PortNameForDebugMonitor[] = "ldr:dmnt";
    }

    Result InitializeForDebugMonitor() NN_NOEXCEPT;
    Result FinalizeForDebugMonitor() NN_NOEXCEPT;

    Result SetProgramArgument2(ncm::ProgramId programId, const void* pArgument, size_t size) NN_NOEXCEPT;
    Result FlushArguments2() NN_NOEXCEPT;
    Result GetProcessModuleInfo(int* pOutCount, ldr::ModuleInfo* pBuffer, int num, nn::os::ProcessId id) NN_NOEXCEPT;


} // end of namespace ldr
} // end of namespace nn
