﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <memory>
#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/nn_SdkAssert.h>

namespace nn { namespace kvdb {

    class AutoBuffer
    {
        NN_DISALLOW_COPY(AutoBuffer);

    public:
        AutoBuffer() NN_NOEXCEPT : m_Size(0){}
        Result Initialize(size_t size) NN_NOEXCEPT;
        Result Initialize(const void* data, size_t size) NN_NOEXCEPT;

        AutoBuffer(AutoBuffer&& rvalue) NN_NOEXCEPT
        {
            m_Buffer = std::move(rvalue.m_Buffer);
            m_Size = std::move(rvalue.m_Size);
        }

        AutoBuffer& operator=(AutoBuffer&& rvalue) NN_NOEXCEPT
        {
            AutoBuffer(std::move(rvalue)).swap(*this);

            return *this;
        }

        void swap(AutoBuffer& other) NN_NOEXCEPT
        {
            std::swap(m_Buffer, other.m_Buffer);
            std::swap(m_Size, other.m_Size);
        }

        char* Get() const NN_NOEXCEPT
        {
            return m_Buffer.get();
        }

        size_t GetSize() const NN_NOEXCEPT
        {
            return m_Size;
        }

    private:
        std::unique_ptr<char[]> m_Buffer;
        size_t m_Size;
    };

}}
