﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
    @file
    @brief      kvdb モジュール用の、ログを出力する API の宣言です。
*/

#include <nn/nn_Common.h>
#include <nn/diag/detail/diag_DetailStructuredSdkLog.h>

#define NN_DETAIL_KVDB_TRACE(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(kvdb, Trace, 0, ##__VA_ARGS__)
#define NN_DETAIL_KVDB_TRACE_V1(...)                NN_DETAIL_STRUCTURED_SDK_LOG(kvdb, Trace, 1, ##__VA_ARGS__)
#define NN_DETAIL_KVDB_TRACE_V2(...)                NN_DETAIL_STRUCTURED_SDK_LOG(kvdb, Trace, 2, ##__VA_ARGS__)
#define NN_DETAIL_KVDB_TRACE_V3(...)                NN_DETAIL_STRUCTURED_SDK_LOG(kvdb, Trace, 3, ##__VA_ARGS__)

#define NN_DETAIL_KVDB_INFO(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(kvdb, Info, 0, ##__VA_ARGS__)
#define NN_DETAIL_KVDB_INFO_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(kvdb, Info, 1, ##__VA_ARGS__)
#define NN_DETAIL_KVDB_INFO_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(kvdb, Info, 2, ##__VA_ARGS__)
#define NN_DETAIL_KVDB_INFO_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(kvdb, Info, 3, ##__VA_ARGS__)

#define NN_DETAIL_KVDB_WARN(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(kvdb, Warn, 0, ##__VA_ARGS__)
#define NN_DETAIL_KVDB_WARN_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(kvdb, Warn, 1, ##__VA_ARGS__)
#define NN_DETAIL_KVDB_WARN_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(kvdb, Warn, 2, ##__VA_ARGS__)
#define NN_DETAIL_KVDB_WARN_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(kvdb, Warn, 3, ##__VA_ARGS__)

#define NN_DETAIL_KVDB_ERROR(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(kvdb, Error, 0, ##__VA_ARGS__)
#define NN_DETAIL_KVDB_ERROR_V1(...)                NN_DETAIL_STRUCTURED_SDK_LOG(kvdb, Error, 1, ##__VA_ARGS__)
#define NN_DETAIL_KVDB_ERROR_V2(...)                NN_DETAIL_STRUCTURED_SDK_LOG(kvdb, Error, 2, ##__VA_ARGS__)
#define NN_DETAIL_KVDB_ERROR_V3(...)                NN_DETAIL_STRUCTURED_SDK_LOG(kvdb, Error, 3, ##__VA_ARGS__)

#define NN_DETAIL_KVDB_FATAL(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(kvdb, Fatal, 0, ##__VA_ARGS__)
#define NN_DETAIL_KVDB_FATAL_V1(...)                NN_DETAIL_STRUCTURED_SDK_LOG(kvdb, Fatal, 1, ##__VA_ARGS__)
#define NN_DETAIL_KVDB_FATAL_V2(...)                NN_DETAIL_STRUCTURED_SDK_LOG(kvdb, Fatal, 2, ##__VA_ARGS__)
#define NN_DETAIL_KVDB_FATAL_V3(...)                NN_DETAIL_STRUCTURED_SDK_LOG(kvdb, Fatal, 3, ##__VA_ARGS__)

#define NN_DETAIL_KVDB_VTRACE(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(kvdb, Trace, 0, format, args)
#define NN_DETAIL_KVDB_VTRACE_V1(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(kvdb, Trace, 1, format, args)
#define NN_DETAIL_KVDB_VTRACE_V2(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(kvdb, Trace, 2, format, args)
#define NN_DETAIL_KVDB_VTRACE_V3(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(kvdb, Trace, 3, format, args)

#define NN_DETAIL_KVDB_VINFO(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(kvdb, Info, 0, format, args)
#define NN_DETAIL_KVDB_VINFO_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(kvdb, Info, 1, format, args)
#define NN_DETAIL_KVDB_VINFO_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(kvdb, Info, 2, format, args)
#define NN_DETAIL_KVDB_VINFO_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(kvdb, Info, 3, format, args)

#define NN_DETAIL_KVDB_VWARN(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(kvdb, Warn, 0, format, args)
#define NN_DETAIL_KVDB_VWARN_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(kvdb, Warn, 1, format, args)
#define NN_DETAIL_KVDB_VWARN_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(kvdb, Warn, 2, format, args)
#define NN_DETAIL_KVDB_VWARN_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(kvdb, Warn, 3, format, args)

#define NN_DETAIL_KVDB_VERROR(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(kvdb, Error, 0, format, args)
#define NN_DETAIL_KVDB_VERROR_V1(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(kvdb, Error, 1, format, args)
#define NN_DETAIL_KVDB_VERROR_V2(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(kvdb, Error, 2, format, args)
#define NN_DETAIL_KVDB_VERROR_V3(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(kvdb, Error, 3, format, args)

#define NN_DETAIL_KVDB_VFATAL(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(kvdb, Fatal, 0, format, args)
#define NN_DETAIL_KVDB_VFATAL_V1(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(kvdb, Fatal, 1, format, args)
#define NN_DETAIL_KVDB_VFATAL_V2(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(kvdb, Fatal, 2, format, args)
#define NN_DETAIL_KVDB_VFATAL_V3(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(kvdb, Fatal, 3, format, args)

#define NN_DETAIL_KVDB_PUT_TRACE(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(kvdb, Trace, 0, text, length)
#define NN_DETAIL_KVDB_PUT_TRACE_V1(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(kvdb, Trace, 1, text, length)
#define NN_DETAIL_KVDB_PUT_TRACE_V2(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(kvdb, Trace, 2, text, length)
#define NN_DETAIL_KVDB_PUT_TRACE_V3(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(kvdb, Trace, 3, text, length)

#define NN_DETAIL_KVDB_PUT_INFO(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(kvdb, Info, 0, text, length)
#define NN_DETAIL_KVDB_PUT_INFO_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(kvdb, Info, 1, text, length)
#define NN_DETAIL_KVDB_PUT_INFO_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(kvdb, Info, 2, text, length)
#define NN_DETAIL_KVDB_PUT_INFO_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(kvdb, Info, 3, text, length)

#define NN_DETAIL_KVDB_PUT_WARN(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(kvdb, Warn, 0, text, length)
#define NN_DETAIL_KVDB_PUT_WARN_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(kvdb, Warn, 1, text, length)
#define NN_DETAIL_KVDB_PUT_WARN_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(kvdb, Warn, 2, text, length)
#define NN_DETAIL_KVDB_PUT_WARN_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(kvdb, Warn, 3, text, length)

#define NN_DETAIL_KVDB_PUT_ERROR(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(kvdb, Error, 0, text, length)
#define NN_DETAIL_KVDB_PUT_ERROR_V1(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(kvdb, Error, 1, text, length)
#define NN_DETAIL_KVDB_PUT_ERROR_V2(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(kvdb, Error, 2, text, length)
#define NN_DETAIL_KVDB_PUT_ERROR_V3(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(kvdb, Error, 3, text, length)

#define NN_DETAIL_KVDB_PUT_FATAL(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(kvdb, Fatal, 0, text, length)
#define NN_DETAIL_KVDB_PUT_FATAL_V1(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(kvdb, Fatal, 1, text, length)
#define NN_DETAIL_KVDB_PUT_FATAL_V2(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(kvdb, Fatal, 2, text, length)
#define NN_DETAIL_KVDB_PUT_FATAL_V3(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(kvdb, Fatal, 3, text, length)
