﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
*   @file
*   @brief  htclow のモジュールに関する型定義
*/

#pragma once

#include <nn/nn_Common.h>

namespace nn { namespace htclow {

/**
*   @brief  htclow モジュールの識別子
*/
enum class ModuleId : uint8_t
{
    Tm = 0,
    Fs = 1,
    Htcs = 2,
    HtcEnv = 3,
};

/**
*   @brief  htclow モジュールを表す構造体
*/
struct ModuleType
{
    bool _isInitialized;
    ModuleId _id;
};

}}
