﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
*   @file
*   @brief  htclow のモジュールに関するユーティリティクラス
*/

#pragma once

#include <nn/nn_Common.h>

#include <nn/htclow/htclow_ModuleTypes.h>
#include <nn/htclow/htclow_ModuleApi.h>

namespace nn { namespace htclow {

/**
*   @brief  htclow のモジュールに関するユーティリティクラス
*/
class Module final
{
public:
    explicit Module(ModuleId id) NN_NOEXCEPT
    {
        nn::htclow::InitializeModule(&m_Impl, id);
    }

    ~Module() NN_NOEXCEPT
    {
        nn::htclow::FinalizeModule(&m_Impl);
    }

    ModuleType* GetBase() NN_NOEXCEPT
    {
        return &m_Impl;
    }

    const ModuleType* GetBase() const NN_NOEXCEPT
    {
        return &m_Impl;
    }

private:
    ModuleType m_Impl;
};

}}
