﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/nn_StaticAssert.h>

#include <nn/htclow/htclow_ChannelTypes.h>

namespace nn { namespace htclow { namespace detail {

struct ChannelInternalType
{
    ChannelId channelId;
    int8_t reserved;
    ModuleId moduleId;
};

NN_STATIC_ASSERT(sizeof(ChannelInternalType) == 4);

NN_FORCEINLINE ChannelInternalType ConvertChannelType(nn::htclow::ChannelType channelType) NN_NOEXCEPT
{
    return ChannelInternalType {
        channelType._channelId,
        0,
        channelType._moduleId,
    };
}

NN_FORCEINLINE bool operator==(const ChannelInternalType& t1, const ChannelInternalType& t2) NN_NOEXCEPT
{
    return t1.moduleId == t2.moduleId && t1.reserved == t2.reserved && t1.channelId == t2.channelId;
}

NN_FORCEINLINE bool operator!=(const ChannelInternalType& t1, const ChannelInternalType& t2) NN_NOEXCEPT
{
    return !(t1 == t2);
}

NN_FORCEINLINE bool operator<(const ChannelInternalType& t1, const ChannelInternalType& t2) NN_NOEXCEPT
{
    if (t1.moduleId < t2.moduleId)
    {
        return true;
    }
    else if (t1.reserved < t2.reserved)
    {
        return true;
    }
    else if (t1.channelId < t2.channelId)
    {
        return true;
    }
    else
    {
        return false;
    }
}

NN_FORCEINLINE bool operator>(const ChannelInternalType& t1, const ChannelInternalType& t2) NN_NOEXCEPT
{
    return t2 < t1;
}

NN_FORCEINLINE bool operator<=(const ChannelInternalType& t1, const ChannelInternalType& t2) NN_NOEXCEPT
{
    return !(t1 > t2);
}

NN_FORCEINLINE bool operator>=(const ChannelInternalType& t1, const ChannelInternalType& t2) NN_NOEXCEPT
{
    return !(t1 < t2);
}

}}}
