﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

#include <nn/fs/fsa/fs_IFileSystem.h>

namespace nn { namespace fs { namespace fsa {

class IFile;
class IDirectory;

}}}

namespace nn { namespace fssystem { namespace save {

namespace detail {

class SaveDataInternalStorageFile;
class IntegrityVerificationInternalStorageFile;
class SaveDataInternalStorageDirectory;

}

class IInternalStorageFileSystem;

// セーブデータのための内部ストレージアクセス用疑似ファイルシステム
class SaveDataInternalStorageFileSystem : public fs::fsa::IFileSystem, public fs::detail::Newable
{
    NN_DISALLOW_COPY(SaveDataInternalStorageFileSystem);

    friend class detail::SaveDataInternalStorageFile;
    friend class detail::IntegrityVerificationInternalStorageFile;
    friend class detail::SaveDataInternalStorageDirectory;

    static const int64_t HashSize = nn::crypto::Sha256Generator::HashSize;

public:
    explicit SaveDataInternalStorageFileSystem() NN_NOEXCEPT
        : m_pInternalStorageFileSystem(nullptr)
    {
    }

    virtual ~SaveDataInternalStorageFileSystem() NN_NOEXCEPT NN_OVERRIDE {}

public:
    Result Initialize(
        IInternalStorageFileSystem* pInternalStorageFileSystem
    ) NN_NOEXCEPT;

private:
    static const int PathLengthMax = 256;

private:
    virtual Result DoCreateFile(const char* path, int64_t size, int option) NN_NOEXCEPT NN_OVERRIDE;
    virtual Result DoDeleteFile(const char* path) NN_NOEXCEPT NN_OVERRIDE;
    virtual Result DoCreateDirectory(const char* path) NN_NOEXCEPT NN_OVERRIDE;
    virtual Result DoDeleteDirectory(const char* path) NN_NOEXCEPT NN_OVERRIDE;
    virtual Result DoDeleteDirectoryRecursively(const char* path) NN_NOEXCEPT NN_OVERRIDE;
    virtual Result DoCleanDirectoryRecursively(const char* path) NN_NOEXCEPT NN_OVERRIDE;
    virtual Result DoRenameFile(const char* currentPath, const char* newPath) NN_NOEXCEPT NN_OVERRIDE;
    virtual Result DoRenameDirectory(const char* currentPath, const char* newPath) NN_NOEXCEPT NN_OVERRIDE;
    virtual Result DoGetEntryType(fs::DirectoryEntryType* outValue, const char* path) NN_NOEXCEPT NN_OVERRIDE;
    virtual Result DoOpenFile(std::unique_ptr<fs::fsa::IFile>* outValue, const char* path, fs::OpenMode mode) NN_NOEXCEPT NN_OVERRIDE;
    virtual Result DoOpenDirectory(std::unique_ptr<fs::fsa::IDirectory>* outValue, const char* path, fs::OpenDirectoryMode mode) NN_NOEXCEPT NN_OVERRIDE;
    virtual Result DoCommit() NN_NOEXCEPT NN_OVERRIDE;
    virtual Result DoCommitProvisionally(int64_t counter) NN_NOEXCEPT NN_OVERRIDE;
    virtual Result DoRollback() NN_NOEXCEPT NN_OVERRIDE;

private:
    IInternalStorageFileSystem* m_pInternalStorageFileSystem;
};

}}}

