﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <memory>

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>

#include <nn/fs/detail/fs_Newable.h>
#include <nn/fs/fs_IStorage.h>

#include <nn/fssystem/fs_PartitionFileSystemMeta.h>

#include <nn/fs/fsa/fs_IFileSystem.h>
#include <nn/fs/fsa/fs_IFile.h>
#include <nn/fs/fsa/fs_IDirectory.h>

namespace nn { namespace fssystem {


    template <typename MetaData>
    class PartitionFileSystemCore : public nn::fs::detail::Newable, public nn::fs::fsa::IFileSystem
    {
    private:
        class PartitionFile;
        class PartitionDirectory;

        fs::IStorage* m_pBaseFile;
        MetaData* m_pMetaData;
        bool m_IsInitialized;

        size_t m_MetaDataSize;

        std::unique_ptr<MetaData> m_pUniqueMetaData;
        std::shared_ptr<fs::IStorage> m_pSharedStorage;

    private:
        Result Initialize(fs::IStorage* pBaseStorage, MemoryResource* pAllocator) NN_NOEXCEPT;

    public:
        PartitionFileSystemCore() NN_NOEXCEPT;

        virtual ~PartitionFileSystemCore() NN_NOEXCEPT NN_OVERRIDE;

        Result Initialize(fs::IStorage* pBaseFile) NN_NOEXCEPT; // obsolete
        Result Initialize(std::shared_ptr<fs::IStorage> pBaseStorage) NN_NOEXCEPT;
        Result Initialize(std::shared_ptr<fs::IStorage> pBaseStorage, MemoryResource* pAllocator) NN_NOEXCEPT;
        Result Initialize(std::unique_ptr<MetaData>&& pMetaData, std::shared_ptr<fs::IStorage> pBaseStorage) NN_NOEXCEPT;
        Result Initialize(MetaData* pMetaData, std::shared_ptr<fs::IStorage> pBaseStorage) NN_NOEXCEPT;

        Result GetFileBaseOffset(int64_t* outValue, const char* path) NN_NOEXCEPT;

        virtual Result DoOpenFile(std::unique_ptr<nn::fs::fsa::IFile>* outValue, const char* path, nn::fs::OpenMode mode) NN_NOEXCEPT NN_OVERRIDE;
        virtual Result DoOpenDirectory(std::unique_ptr<nn::fs::fsa::IDirectory>* outValue, const char* path, nn::fs::OpenDirectoryMode mode) NN_NOEXCEPT NN_OVERRIDE;
        virtual Result DoGetEntryType(nn::fs::DirectoryEntryType* outValue, const char* path) NN_NOEXCEPT NN_OVERRIDE;

        virtual Result DoCreateFile(const char *path, int64_t size, int option) NN_NOEXCEPT NN_OVERRIDE;
        virtual Result DoDeleteFile(const char *path) NN_NOEXCEPT NN_OVERRIDE;
        virtual Result DoCreateDirectory(const char *path) NN_NOEXCEPT NN_OVERRIDE;
        virtual Result DoDeleteDirectory(const char *path) NN_NOEXCEPT NN_OVERRIDE;
        virtual Result DoDeleteDirectoryRecursively(const char *path) NN_NOEXCEPT NN_OVERRIDE;
        virtual Result DoCleanDirectoryRecursively(const char *path) NN_NOEXCEPT NN_OVERRIDE;
        virtual Result DoRenameFile(const char *currentPath, const char *newPath) NN_NOEXCEPT NN_OVERRIDE;
        virtual Result DoRenameDirectory(const char *currentPath, const char *newPath) NN_NOEXCEPT NN_OVERRIDE;
        virtual Result DoCommit() NN_NOEXCEPT NN_OVERRIDE;
    };

    typedef PartitionFileSystemCore<PartitionFileSystemMeta> PartitionFileSystem;
    typedef PartitionFileSystemCore<Sha256PartitionFileSystemMeta> Sha256PartitionFileSystem;

}}

