﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

// このファイルは SFDL による自動生成ファイルです。
// 手動で変更しないでください。
// This file is auto-generated by the SFDL code generator.
// Do not modify manually.

#include <cstdint>
#include <nn/nn_BitTypes.h>
#include <nn/nn_Result.h>
#include <nn/sf/sf_Types.h>
#include <nn/sf/cmif/detail/sf_CmifAutogenInterfaceIncludes.h>
#include <nn/sf/detail/sf_AutogenInterfaceIncludes.h>
#include <nn/sf/impl/detail/sf_AutogenImplIncludes.h>

namespace nn { namespace fssrv { namespace sf { // NOLINT(whitespace/braces)

class IProgramRegistry;

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IProgramRegistry, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IProgramRegistry)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RegisterProgram, (::std::uint64_t processId, ::std::uint64_t programId, ::std::uint8_t storageId, const ::nn::sf::InBuffer& fsAccessControlData, ::std::int64_t dataSize, const ::nn::sf::InBuffer& fsAccessControlDesc, ::std::int64_t descSize))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(UnregisterProgram, (::std::uint64_t processId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetCurrentProcess, (::nn::Bit64 processId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetEnabledProgramVerification, (bool isEnabled))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IProgramRegistry)

        ::nn::Result RegisterProgram(::std::uint64_t processId, ::std::uint64_t programId, ::std::uint8_t storageId, const ::nn::sf::InBuffer& fsAccessControlData, ::std::int64_t dataSize, const ::nn::sf::InBuffer& fsAccessControlDesc, ::std::int64_t descSize) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RegisterProgram, (processId, programId, storageId, fsAccessControlData, dataSize, fsAccessControlDesc, descSize));
        }

        ::nn::Result UnregisterProgram(::std::uint64_t processId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(UnregisterProgram, (processId));
        }

        ::nn::Result SetCurrentProcess(::nn::Bit64 processId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetCurrentProcess, (processId));
        }

        ::nn::Result SetEnabledProgramVerification(bool isEnabled) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetEnabledProgramVerification, (isEnabled));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IProgramRegistry
    {
    public:
        nn::Result RegisterProgram(std::uint64_t processId, std::uint64_t programId, std::uint8_t storageId, const nn::sf::InBuffer& fsAccessControlData, std::int64_t dataSize, const nn::sf::InBuffer& fsAccessControlDesc, std::int64_t descSize) NN_NOEXCEPT;
        nn::Result UnregisterProgram(std::uint64_t processId) NN_NOEXCEPT;
        nn::Result SetCurrentProcess(nn::Bit64 processId) NN_NOEXCEPT;
        nn::Result SetEnabledProgramVerification(bool isEnabled) NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result RegisterProgram(std::uint64_t processId, std::uint64_t programId, std::uint8_t storageId, const nn::sf::InBuffer& fsAccessControlData, std::int64_t dataSize, const nn::sf::InBuffer& fsAccessControlDesc, std::int64_t descSize) NN_NOEXCEPT;
    nn::Result UnregisterProgram(std::uint64_t processId) NN_NOEXCEPT;
    nn::Result SetCurrentProcess(nn::Bit64 processId) NN_NOEXCEPT;
    nn::Result SetEnabledProgramVerification(bool isEnabled) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::fssrv::sf::IProgramRegistry))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RegisterProgram, (::std::uint64_t processId, ::std::uint64_t programId, ::std::uint8_t storageId, const ::nn::sf::InBuffer& fsAccessControlData, ::std::int64_t dataSize, const ::nn::sf::InBuffer& fsAccessControlDesc, ::std::int64_t descSize))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RegisterProgram, (processId, programId, storageId, fsAccessControlData, dataSize, fsAccessControlDesc, descSize));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(UnregisterProgram, (::std::uint64_t processId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(UnregisterProgram, (processId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetCurrentProcess, (::nn::Bit64 processId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetCurrentProcess, (processId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetEnabledProgramVerification, (bool isEnabled))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetEnabledProgramVerification, (isEnabled));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::fssrv::sf::IProgramRegistry>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::fssrv::sf::IProgramRegistry))

    // nn::Result RegisterProgram(std::uint64_t processId, std::uint64_t programId, std::uint8_t storageId, const nn::sf::InBuffer& fsAccessControlData, std::int64_t dataSize, const nn::sf::InBuffer& fsAccessControlDesc, std::int64_t descSize) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RegisterProgram)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(fsAccessControlData, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(fsAccessControlDesc, 1, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (fsAccessControlData, fsAccessControlDesc))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(storageId, (::std::uint8_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(processId, (::std::uint64_t), 8)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(programId, (::std::uint64_t), 16)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(dataSize, (::std::int64_t), 24)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(descSize, (::std::int64_t), 32)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(5, (storageId, processId, programId, dataSize, descSize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(40)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(processId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(programId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(storageId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(fsAccessControlData), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(dataSize), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(fsAccessControlDesc), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(descSize)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RegisterProgram)

    // nn::Result UnregisterProgram(std::uint64_t processId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(UnregisterProgram)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(processId, (::std::uint64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (processId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(processId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(UnregisterProgram)

    // nn::Result SetCurrentProcess(nn::Bit64 processId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetCurrentProcess)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(processId, (::nn::Bit64), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (processId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(processId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetCurrentProcess)

    // nn::Result SetEnabledProgramVerification(bool isEnabled) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetEnabledProgramVerification)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(256)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(isEnabled, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (isEnabled))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(isEnabled)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetEnabledProgramVerification)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::fssrv::sf::IProgramRegistry, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::fssrv::sf::IProgramRegistry))

    // nn::Result RegisterProgram(std::uint64_t processId, std::uint64_t programId, std::uint8_t storageId, const nn::sf::InBuffer& fsAccessControlData, std::int64_t dataSize, const nn::sf::InBuffer& fsAccessControlDesc, std::int64_t descSize) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RegisterProgram, (::std::uint64_t processId, ::std::uint64_t programId, ::std::uint8_t storageId, const ::nn::sf::InBuffer& fsAccessControlData, ::std::int64_t dataSize, const ::nn::sf::InBuffer& fsAccessControlDesc, ::std::int64_t descSize))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RegisterProgram)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(processId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(programId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(storageId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(fsAccessControlData)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(dataSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(fsAccessControlDesc)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(descSize)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RegisterProgram)
    }

    // nn::Result UnregisterProgram(std::uint64_t processId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(UnregisterProgram, (::std::uint64_t processId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(UnregisterProgram)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(processId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(UnregisterProgram)
    }

    // nn::Result SetCurrentProcess(nn::Bit64 processId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetCurrentProcess, (::nn::Bit64 processId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetCurrentProcess)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(processId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetCurrentProcess)
    }

    // nn::Result SetEnabledProgramVerification(bool isEnabled) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetEnabledProgramVerification, (bool isEnabled))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetEnabledProgramVerification)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(isEnabled)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetEnabledProgramVerification)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::fssrv::sf::IProgramRegistry>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::fssrv::sf::IProgramRegistry))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RegisterProgram)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(fsAccessControlData)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(fsAccessControlDesc)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RegisterProgram)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(processId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(programId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(storageId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(fsAccessControlData),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(dataSize),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(fsAccessControlDesc),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(descSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(UnregisterProgram)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(UnregisterProgram)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(processId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetCurrentProcess)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OVERWRITE_IN_PROCESS_ID(processId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetCurrentProcess)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(processId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetEnabledProgramVerification)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetEnabledProgramVerification)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(isEnabled)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RegisterProgram)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(UnregisterProgram)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetCurrentProcess)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetEnabledProgramVerification)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::fssrv::sf::IProgramRegistry))
