﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

namespace nn { namespace fssrv {

    struct SaveDataTransferCryptoConfiguration
    {
    public:
        enum class KeyIndex
        {
            SaveDataTransferToken,
            SaveDataTransfer,

            CloudBackUpToken,
            CloudBackUpData,

            Count,
        };

        static const int TokenSignKeyModulusSize = 256;
        static const int KspSignKeyModulusSize = 256;

    public:
        uint8_t tokenSignKeyModulus[TokenSignKeyModulusSize]; // セーブデータ移行用
        uint8_t kspSignKeyModulus[KspSignKeyModulusSize];     // クラウドバックアップ用
        void(*pGenerateAesKey)(void* outValue, size_t size, KeyIndex keyIndex, const void* pKeySource, size_t keySourceSize) NN_NOEXCEPT;
        void(*pGenerateRandom)(void* outValue, size_t size) NN_NOEXCEPT;
    };

}}
