﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/fs/fs_Result.h>
#include <nn/fs/fs_SaveDataPrivate.h>
#include <nn/fssrv/sf/fssrv_ISaveDataInfoReader.h>

namespace nn { namespace fssrv {

    class SaveDataInfoReaderImpl
    {
    public:
        virtual nn::Result Read(nn::sf::Out<std::int64_t> outValue, const nn::sf::OutBuffer& outEntries) NN_NOEXCEPT = 0;
        virtual ~SaveDataInfoReaderImpl() NN_NOEXCEPT {};
    };

}}
