﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
*   @file
*   @brief  システム BCAT セーブデータ関連 API の宣言
*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/fs/fs_SaveDataTypes.h>

namespace nn { namespace fs {

/**
* @brief システム BCAT セーブデータの識別子です。
*/
typedef uint64_t SystemBcatSaveDataId;

//! @name システム BCAT セーブデータ関連 API
//! @{

//--------------------------------------------------------------------------
/**
*   @brief      システム BCAT セーブデータを作成します。
*
*   @param[in]  systemSaveDataId    システム BCAT セーブデータの識別子
*   @param[in]  size                セーブデータのデータ保存領域のバイトサイズ
*   @param[in]  flags               セーブデータのフラグ集合
*
*   @return     処理の結果が返ります。
*   @retval     ResultSuccess               成功しました。
*
*   @pre
*       - size >= 0
*/
Result CreateSystemBcatSaveData(SystemBcatSaveDataId systemBcatSaveDataId, int64_t size, uint32_t flags) NN_NOEXCEPT;

//--------------------------------------------------------------------------
/**
*   @brief      ID に紐づいたシステム BCAT セーブデータをマウントします。
*
*   @param[in]  name       マウント名
*   @param[in]  id         システム BCAT セーブデータの識別子
*
*   @return     処理の結果が返ります。
*   @retval     ResultSuccess               成功しました。
*
*   @pre
*       - name が @link mount_name 有効なマウント名 @endlink である。
*/
Result MountSystemBcatSaveData(const char* name, SystemBcatSaveDataId id) NN_NOEXCEPT;

//! @}

}} // namespace nn::fs

