﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Result.h>

namespace nn { namespace fs {

/**
* @brief アクセスログの出力モード識別子です。
*/
enum AccessLogMode : uint32_t
{
    AccessLogMode_Off = 0x0,
    AccessLogMode_Log = 0x1,
    AccessLogMode_SdCard = 0x2,
};

/**
*   @brief      アクセスログのグローバル設定を取得します。
*
*   @param[out]  pOutAccessLogMode    ログ出力のモード指定
*
*   @return     処理の結果が返ります。
*   @retval     ResultSuccess                   成功しました。
*/
nn::Result GetGlobalAccessLogMode(uint32_t* pOutAccessLogMode) NN_NOEXCEPT;

/**
*   @brief      アクセスログのグローバル設定を変更します。
*
*   @param[in]  accessLogMode    ログ出力のモード指定
*
*   @return     処理の結果が返ります。
*   @retval     ResultSuccess                   成功しました。
*/
nn::Result SetGlobalAccessLogMode(uint32_t accessLogMode) NN_NOEXCEPT;

/**
*   @brief      アクセスログの設定を変更します。
*
*   @param[in]  isEnabled    true なら有効化、false なら無効化
*
*   @return     なし
*/
void SetLocalAccessLog(bool isEnabled) NN_NOEXCEPT;

#if !defined(NN_SDK_BUILD_RELEASE)

/**
*   @brief      システムプロセス・アプレットのアクセスログの設定を変更します。
*
*   @param[in]  isEnabled    true なら有効化、false なら無効化
*
*   @details    システム開発者向け
*               他の fs 関数の呼び出しをする前に呼び出して使用します。
*               ビルドタイプは Develop である必要があります。
*               セキュリティの都合上、SD カード出力には対応していません。
*               本関数はデバッグ用関数のため、呼び出したままの状態でマージしないようご注意ください。
*   @return     なし
*/
void SetLocalSystemAccessLogForDebug(bool isEnabled) NN_NOEXCEPT;

#endif

}}
