﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

namespace nn {
namespace detail {

struct SystemThreadInfo
{
    int priority;
    const char* name;
};

#define NN_DETAIL_SYSTEM_THREAD_NAME_PREFIX "nn."

#define NN_DETAIL_DEFINE_SYSTEM_THREAD(_priority_, _module_, _name_) \
    const ::nn::detail::SystemThreadInfo SystemThreadInfoDef##_module_##_name_ = { _priority_, NN_DETAIL_SYSTEM_THREAD_NAME_PREFIX #_module_ "." #_name_};

// 現状スレッド優先度定義の分岐に適した構成が存在しないため、ハードウェア構成で分岐する
#if defined(NN_BUILD_CONFIG_HARDWARE_JETSONTX2)
#    include <nn/detail/nn_SystemThreadDefinitionDetail-hardware.jetsontx2.h>
#elif defined(NN_BUILD_CONFIG_HARDWARE_NX) || defined(NN_BUILD_CONFIG_HARDWARE_JETSONTK2)
// TORIAEZU: JetsonTk2 も NXFP2 のスレッド優先度定義を流用
#    include <nn/detail/nn_SystemThreadDefinitionDetail-hardware.NX.h>
#else
#    include <nn/detail/nn_SystemThreadDefinitionDetail-default.h>
#endif

}
}
