﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
    @file
    @brief      dd モジュール用の、ログを出力する API の宣言です。
*/

#include <nn/nn_Common.h>
#include <nn/diag/detail/diag_DetailStructuredSdkLog.h>

#define NN_DETAIL_DD_TRACE(...)                     NN_DETAIL_STRUCTURED_SDK_LOG(dd, Trace, 0, ##__VA_ARGS__)
#define NN_DETAIL_DD_TRACE_V1(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(dd, Trace, 1, ##__VA_ARGS__)
#define NN_DETAIL_DD_TRACE_V2(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(dd, Trace, 2, ##__VA_ARGS__)
#define NN_DETAIL_DD_TRACE_V3(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(dd, Trace, 3, ##__VA_ARGS__)

#define NN_DETAIL_DD_INFO(...)                      NN_DETAIL_STRUCTURED_SDK_LOG(dd, Info, 0, ##__VA_ARGS__)
#define NN_DETAIL_DD_INFO_V1(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(dd, Info, 1, ##__VA_ARGS__)
#define NN_DETAIL_DD_INFO_V2(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(dd, Info, 2, ##__VA_ARGS__)
#define NN_DETAIL_DD_INFO_V3(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(dd, Info, 3, ##__VA_ARGS__)

#define NN_DETAIL_DD_WARN(...)                      NN_DETAIL_STRUCTURED_SDK_LOG(dd, Warn, 0, ##__VA_ARGS__)
#define NN_DETAIL_DD_WARN_V1(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(dd, Warn, 1, ##__VA_ARGS__)
#define NN_DETAIL_DD_WARN_V2(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(dd, Warn, 2, ##__VA_ARGS__)
#define NN_DETAIL_DD_WARN_V3(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(dd, Warn, 3, ##__VA_ARGS__)

#define NN_DETAIL_DD_ERROR(...)                     NN_DETAIL_STRUCTURED_SDK_LOG(dd, Error, 0, ##__VA_ARGS__)
#define NN_DETAIL_DD_ERROR_V1(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(dd, Error, 1, ##__VA_ARGS__)
#define NN_DETAIL_DD_ERROR_V2(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(dd, Error, 2, ##__VA_ARGS__)
#define NN_DETAIL_DD_ERROR_V3(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(dd, Error, 3, ##__VA_ARGS__)

#define NN_DETAIL_DD_FATAL(...)                     NN_DETAIL_STRUCTURED_SDK_LOG(dd, Fatal, 0, ##__VA_ARGS__)
#define NN_DETAIL_DD_FATAL_V1(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(dd, Fatal, 1, ##__VA_ARGS__)
#define NN_DETAIL_DD_FATAL_V2(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(dd, Fatal, 2, ##__VA_ARGS__)
#define NN_DETAIL_DD_FATAL_V3(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(dd, Fatal, 3, ##__VA_ARGS__)

#define NN_DETAIL_DD_VTRACE(format, args)           NN_DETAIL_STRUCTURED_SDK_VLOG(dd, Trace, 0, format, args)
#define NN_DETAIL_DD_VTRACE_V1(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(dd, Trace, 1, format, args)
#define NN_DETAIL_DD_VTRACE_V2(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(dd, Trace, 2, format, args)
#define NN_DETAIL_DD_VTRACE_V3(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(dd, Trace, 3, format, args)

#define NN_DETAIL_DD_VINFO(format, args)            NN_DETAIL_STRUCTURED_SDK_VLOG(dd, Info, 0, format, args)
#define NN_DETAIL_DD_VINFO_V1(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(dd, Info, 1, format, args)
#define NN_DETAIL_DD_VINFO_V2(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(dd, Info, 2, format, args)
#define NN_DETAIL_DD_VINFO_V3(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(dd, Info, 3, format, args)

#define NN_DETAIL_DD_VWARN(format, args)            NN_DETAIL_STRUCTURED_SDK_VLOG(dd, Warn, 0, format, args)
#define NN_DETAIL_DD_VWARN_V1(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(dd, Warn, 1, format, args)
#define NN_DETAIL_DD_VWARN_V2(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(dd, Warn, 2, format, args)
#define NN_DETAIL_DD_VWARN_V3(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(dd, Warn, 3, format, args)

#define NN_DETAIL_DD_VERROR(format, args)           NN_DETAIL_STRUCTURED_SDK_VLOG(dd, Error, 0, format, args)
#define NN_DETAIL_DD_VERROR_V1(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(dd, Error, 1, format, args)
#define NN_DETAIL_DD_VERROR_V2(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(dd, Error, 2, format, args)
#define NN_DETAIL_DD_VERROR_V3(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(dd, Error, 3, format, args)

#define NN_DETAIL_DD_VFATAL(format, args)           NN_DETAIL_STRUCTURED_SDK_VLOG(dd, Fatal, 0, format, args)
#define NN_DETAIL_DD_VFATAL_V1(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(dd, Fatal, 1, format, args)
#define NN_DETAIL_DD_VFATAL_V2(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(dd, Fatal, 2, format, args)
#define NN_DETAIL_DD_VFATAL_V3(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(dd, Fatal, 3, format, args)

#define NN_DETAIL_DD_PUT_TRACE(text, length)        NN_DETAIL_STRUCTURED_SDK_PUT(dd, Trace, 0, text, length)
#define NN_DETAIL_DD_PUT_TRACE_V1(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(dd, Trace, 1, text, length)
#define NN_DETAIL_DD_PUT_TRACE_V2(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(dd, Trace, 2, text, length)
#define NN_DETAIL_DD_PUT_TRACE_V3(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(dd, Trace, 3, text, length)

#define NN_DETAIL_DD_PUT_INFO(text, length)         NN_DETAIL_STRUCTURED_SDK_PUT(dd, Info, 0, text, length)
#define NN_DETAIL_DD_PUT_INFO_V1(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(dd, Info, 1, text, length)
#define NN_DETAIL_DD_PUT_INFO_V2(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(dd, Info, 2, text, length)
#define NN_DETAIL_DD_PUT_INFO_V3(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(dd, Info, 3, text, length)

#define NN_DETAIL_DD_PUT_WARN(text, length)         NN_DETAIL_STRUCTURED_SDK_PUT(dd, Warn, 0, text, length)
#define NN_DETAIL_DD_PUT_WARN_V1(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(dd, Warn, 1, text, length)
#define NN_DETAIL_DD_PUT_WARN_V2(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(dd, Warn, 2, text, length)
#define NN_DETAIL_DD_PUT_WARN_V3(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(dd, Warn, 3, text, length)

#define NN_DETAIL_DD_PUT_ERROR(text, length)        NN_DETAIL_STRUCTURED_SDK_PUT(dd, Error, 0, text, length)
#define NN_DETAIL_DD_PUT_ERROR_V1(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(dd, Error, 1, text, length)
#define NN_DETAIL_DD_PUT_ERROR_V2(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(dd, Error, 2, text, length)
#define NN_DETAIL_DD_PUT_ERROR_V3(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(dd, Error, 3, text, length)

#define NN_DETAIL_DD_PUT_FATAL(text, length)        NN_DETAIL_STRUCTURED_SDK_PUT(dd, Fatal, 0, text, length)
#define NN_DETAIL_DD_PUT_FATAL_V1(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(dd, Fatal, 1, text, length)
#define NN_DETAIL_DD_PUT_FATAL_V2(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(dd, Fatal, 2, text, length)
#define NN_DETAIL_DD_PUT_FATAL_V3(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(dd, Fatal, 3, text, length)
