﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief   デバイスドライバ向けメモリバリアに関する公開ヘッダファイル
 */

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>

namespace nn { namespace dd {

//! @name メモリバリア関連 API
//! @{

/**
 * @brief  これより以前に実行されたすべてのメモリアクセス、及び発行された命令の完了を待ちます
 *
 * @details
 *  これより以前に実行されたすべてのメモリアクセス、及び発行された命令の完了を待ちます。
 *  これらが完了するまで、以後にある命令は実行されません。
 */
void EnsureMemoryAccess() NN_NOEXCEPT;

//! @}

}}  // namespace nn::dd
