﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief   デバイスドライバ向けデバイスアドレス空間に関する公開ヘッダファイル
 */

#pragma once

#include <nn/TargetConfigs/build_Base.h>
#include <nn/TargetConfigs/build_Os.h>

#include <nn/nn_Common.h>

#if   defined(NN_BUILD_CONFIG_OS_HORIZON) && defined(NN_BUILD_CONFIG_HARDWARE_JETSONTK1)
    #include "detail/dd_DeviceAddressSpaceCommon-hw.tk1.h"
#elif defined(NN_BUILD_CONFIG_OS_HORIZON) && defined(NN_BUILD_CONFIG_HARDWARE_JETSONTK2)
    #include "detail/dd_DeviceAddressSpaceCommon-hw.tk2.h"
#elif defined(NN_BUILD_CONFIG_OS_HORIZON) && defined(NN_BUILD_CONFIG_SOC_TEGRA_X1)
    #include "detail/dd_DeviceAddressSpaceCommon-hw.tx1.h"
#else
    #include "detail/dd_DeviceAddressSpaceCommon-hw.common.h"
#endif

namespace nn { namespace dd {

#if defined(NN_BUILD_FOR_DOCUMENT_GENERATION)

//----------------------------------------------------------------------------
//  Doxygen ドキュメント
//----------------------------------------------------------------------------
/**
 * @brief   デバイスグループの名前を表す列挙型です。
 *
 * @details
 *  各列挙子に対応する SW Group については LSI の Technical Reference Manual を参照して下さい。
 *
 */
enum DeviceName
{
    DeviceName_Num
};

#endif  /* NN_BUILD_FOR_DOCUMENT_GENERATION */

//-----------------------------------------------------------------------------
/**
 * @brief   デバイスアドレス空間にマップするメモリ領域のアライメント制約を表す定数です。
 */
const uint64_t DeviceAddressSpaceMemoryRegionAlignment = 4096;


//-----------------------------------------------------------------------------
/**
 * @brief   デバイスアドレス空間にマップするメモリ領域のアライメントを指定するマクロです。
 *
 * @details
 *  デバイスアドレス空間へマップするメモリ領域としてのアライメント制約を
 *  満たすようにするためのマクロです。配列を使ったバッファ定義などに対して、
 *  以下のように使用することで nn::dd::DeviceAddressSpaceMemoryRegionAlignment
 *  の定数値に等しいアライメントに合わせることができます。
 *
 *  使用例：
 *      @code
 *      NN_DD_ALIGNAS_DEVICE_ADDRESS_SPACE_MEMORY  uint8_t deviceMemory[DeviceAddressSpaceMemoryRegionAlignment * 2];
 *      @endcode
 *
 */
#define NN_DD_ALIGNAS_DEVICE_ADDRESS_SPACE_MEMORY   NN_ALIGNAS(4096)

//-----------------------------------------------------------------------------

}}  // namespace nn::dd

