﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Runtime.Serialization;
using System.Text;

namespace SigloNact.Utilities
{
    internal static class DataContractSerializationUtil
    {
        public static byte[] SerializeToBytes<T>(T obj) => DataContractSerializationUtilImpl<T>.SerializeToBytes(obj);
        public static T DeserializeFromBytes<T>(byte[] bytes) => DataContractSerializationUtilImpl<T>.DeserializeFromBytes(bytes);

        private static class DataContractSerializationUtilImpl<T>
        {
            private static readonly DataContractSerializer Serializer = new DataContractSerializer(typeof(T));

            public static byte[] SerializeToBytes(T obj)
            {
                using (var ms = new MemoryStream())
                {
                    Serializer.WriteObject(ms, obj);
                    return ms.ToArray();
                }
            }

            public static T DeserializeFromBytes(byte[] bytes)
            {
                using (var ms = new MemoryStream(bytes))
                {
                    return (T)Serializer.ReadObject(ms);
                }
            }
        }
    }
}
