﻿using Nintendo.Nact.BuiltIn;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace SigloNact.BuiltIns.Target
{
    [NactFunctionContainer]
    public static class MakeSdkDllEntriesContainer
    {
        [NactFunction]
        public static IEnumerable<IEnumerable<object>> MakeSdkDllEntries(IEnumerable<object> sdkDllNames)
        {
            var xs = sdkDllNames.ToList();

            return xs.Select((x, i) =>
                new object[] {
                    (i == xs.Count - 1) ? "sdk" : string.Format("subsdk{0}", i),
                    x
                }
            );
        }
    }
}
