﻿using Nintendo.Nact.BuiltIn;
using Nintendo.Nact.Execution;
using Nintendo.Nact.FileSystem;
using Nintendo.Nact.Utilities;
using System.Text;
using static System.FormattableString;

namespace SigloNact.BuiltIns.Prebuilt
{
    [NactActionFunctionContainer]
    public static class ResolvePrebuiltBaseRevisionContainer
    {
        // baseBranchFile は、ブランチ名を記述したファイルであり、ASCII で改行を含まない
        // (改行を含まないのは、シェルスクリプトで使いやすくするため)。
        [NactActionFunction]
        public static NactActionResult ResolvePrebuiltBaseRevision(
            INactActionContext context,
            FilePath outputFile,
            FilePath baseBranchFile,
            string userSuppliedBaseRevision)
        {
            var helper = context.Helper;

            // prebuilt-base-revision が指定されていたなら、それを書き出して終わり。
            if (userSuppliedBaseRevision != null)
            {
                helper.WriteAllText(outputFile, userSuppliedBaseRevision, Encoding.ASCII);
                return helper.FinishAsSuccess();
            }

            var baseBranch = helper.ReadAllText(baseBranchFile, Encoding.ASCII);

            // git merge-base <baseBranch> HEAD して結果を書き出す。
            var gitResult = helper.ExecuteProgramForStandardOutput(
                RequestResolver.GetGitCommandPath(),
                Invariant($"merge-base {baseBranch} HEAD"));

            if (!gitResult.IsSuccessful)
            {
                return helper.FinishAsFailure();
            }

            var baseRevision = Encoding.ASCII.GetString(gitResult.StandardOutput).Trim();

            // ファイル内容に変化がなければファイルを更新しない
            var newContents = Encoding.ASCII.GetBytes(baseRevision);
            if (!Util.FileHasContents(outputFile.PathString, newContents))
            {
                helper.WriteAllBytes(outputFile, newContents);
            }

            return helper.FinishAsSuccess();
        }
    }
}
