﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace SigloNact.BuiltIns.Prebuilt
{
    internal static class PrebuiltUtility
    {
        public static string GetAuthorizationTargetName()
        {
            return "Nintendo/Siglo Server";
        }

        public static string GenerateErrorMessage(string message, string username, string password, string sourceURI)
        {
            var stringBuilder = new StringBuilder();
            stringBuilder.AppendFormat("{0}\n", message);
            stringBuilder.AppendFormat("  Please check your username/password are correct and URI resource exists.\n");
            stringBuilder.AppendFormat("    username : {0}\n", username);
            stringBuilder.AppendFormat("    password : {0}\n", "***");
            stringBuilder.AppendFormat("    URI      : {0}\n", sourceURI);

            return stringBuilder.ToString();
        }

        public static string GetMessageOfAnnouncementOfSkipDownloadPrebuiltResultsOption()
        {
            var stringBuilder = new StringBuilder();

            stringBuilder.AppendFormat("Note: Access CI to get the prebuilts. If any of the following conditions apply, consider using the 'skip-download-prebuilt-results' option.\n");
            stringBuilder.AppendFormat("\n");
            stringBuilder.AppendFormat("* The latest (or a sufficiently recent) PrebuiltResults***.zip file exists in the Integrate/Prebuilt directory, so you do not need to download it from CI\n");
            stringBuilder.AppendFormat("* You put the latest (or a sufficiently recent) PrebuiltResults***.zip file in the Integrate/Prebuilt directory manually, and so do not need to download it from CI\n");
            stringBuilder.AppendFormat("* You do not need to download it from CI for other reasons");

            return stringBuilder.ToString();
        }

        public static string GetMessageOfAnnouncementOfDetailsPage()
        {
            var stringBuilder = new StringBuilder();

            stringBuilder.AppendFormat("Please see the following page for more details.\n");
            stringBuilder.AppendFormat("http://spdlybra.nintendo.co.jp/confluence/pages/viewpage.action?pageId=80137288");

            return stringBuilder.ToString();
        }
    }
}
