﻿using Nintendo.Nact.BuiltIn;
using Nintendo.Nact.Execution;
using Nintendo.Nact.FileSystem;
using Nintendo.Nact.Utilities;
using SigloNact.Utilities;
using System;
using System.IO;
using static System.FormattableString;

namespace SigloNact.BuiltIns.Packaging
{
    [NactActionFunctionContainer]
    public static class PackagingActions
    {
        [NactActionFunction]
        public static NactActionResult MakeBuildRevisionFile(
            INactActionContext context,
            FilePath outputFile,
            FilePath revisionInfoFile)
        {
            var helper = context.Helper;

            var info = DataContractSerializationUtil.DeserializeFromBytes<GitRevisionInfo>(helper.ReadAllBytes(revisionInfoFile));

            using (var sw = new StreamWriter(helper.CreateFile(outputFile)))
            {
                sw.WriteLine(Invariant($"Branch: {info.BranchName}"));
                sw.WriteLine(Invariant($"Hash: {info.CommitHash}"));
                sw.WriteLine(Invariant($"Number: {info.CommitCount}"));
            }

            return helper.FinishAsSuccess();
        }
    }
}
