﻿using Nintendo.Nact.BuiltIn;
using Nintendo.Nact.Execution;
using Nintendo.Nact.FileSystem;
using Nintendo.Nact.Utilities.ProgramExecution;
using System.Collections.Generic;

namespace SigloNact.BuiltIns.Common
{
    [NactActionFunctionContainer]
    public static class LockingSignFileContainer
    {
        private static object s_Lock = new object();

        [NactActionFunction]
        public static NactActionResult LockingSignFile(
            INactActionContext context,
            FilePath signScriptPath,
            string authenticationFile,
            string inFile,
            string outFile)
        {
            var helper = context.Helper;

            var args = string.Join(" ",
                "-Version 2.0 -ExecutionPolicy ByPass -NoProfile",
                "-Command", signScriptPath.PathString,
                "-AuthenticationFile", authenticationFile,
                "-InFile", inFile,
                "-OutFile", outFile);
            var additionalEnvironmentVariables = new Dictionary<string, string>() { { "LIB", "" } };
            ProgramExecutionResult result;
            lock (s_Lock)
            {
                var path = FilePath.CreateLocalFileSystemPath(ProgramExecutionUtil.SearchExecutablePath("powershell.exe"));
                result = helper.ExecuteProgram(
                    path,
                    args,
                    additionalEnvironmentVariables);
            }

            if (!result.IsSuccessful)
            {
                return helper.FinishWithExitCode(result.ExitCode);
            }

            return helper.FinishAsSuccess();
        }
    }
}
