﻿using Nintendo.Nact.BuiltIn;
using Nintendo.Nact.Execution;
using Nintendo.Nact.FileSystem;
using Nintendo.Nact.Utilities;
using SigloNact.Utilities;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace SigloNact.BuiltIns.Bundle
{
    [NactActionFunctionContainer]
    public static class ConvertShowIncludesActions
    {
        [NactActionFunction]
        public static NactActionResult ConvertShowIncludesForGccClang(
            INactActionContext context,
            FilePath source,
            FilePath destination,
            IReadOnlyCollection<FilePath> filterPaths)
        {
            var helper = context.Helper;

            var encoding = new UTF8Encoding(false);
            var filePaths = CompilerUtil.ExtractMakeDependencies(helper.ReadAllText(source, encoding))
                .Select(file => FilePath.CreateLocalFileSystemPath(file))
                .ToArray();
            var filteredFilePaths = ConvertShowIncludesUtil.GetFilteredPaths(filePaths, filterPaths).ToArray();
            helper.WriteAllText(destination, string.Join("\n", filteredFilePaths.Select(x => x.PathString)), encoding);

            return helper.FinishAsSuccess();
        }

        [NactActionFunction]
        public static NactActionResult ConvertShowIncludesForMsvc(
            INactActionContext context,
            FilePath source,
            FilePath destination,
            IReadOnlyCollection<FilePath> filterPaths)
        {
            var helper = context.Helper;

            var encoding = new UTF8Encoding(false);
            var filePaths = ConvertShowIncludesUtil.ParseMsvcShowIncludes(helper.ReadAllLines(source, encoding))
                .Select(file => Nintendo.Nact.NactUtil.GetPathOnFileSystem(file))
                .ToArray();
            var filteredFilePaths = ConvertShowIncludesUtil.GetFilteredPaths(filePaths, filterPaths).ToArray();
            helper.WriteAllText(destination, string.Join("\n", filteredFilePaths.Select(x => x.PathString)), encoding);

            return helper.FinishAsSuccess();
        }
    }
}
