﻿using Nintendo.Nact;
using Nintendo.Nact.BuiltIn;
using Nintendo.Nact.FileSystem;
using LibGit2Sharp;
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Text.RegularExpressions;

namespace SigloNact.BuiltIns.BuildSystem
{
    [NactFunctionContainer]
    public static class ExternalRepositoryFunctions
    {
        [NactFunction]
        public static IEnumerable<FilePath> GetActiveExternalRepositoryPaths(FilePath repositoryRootPath)
        {
            try
            {
                FilePath[] activeExrepoPaths;
                using (var repo = new Repository(repositoryRootPath.PathString))
                {
                    // exrepo.<path>.<key>=<value> のフォーマットで .git\config に登録される
                    activeExrepoPaths = repo.Config.Select(c => c.Key)
                        .Where(c => c.StartsWith("exrepo.", StringComparison.Ordinal))
                        .Select(c => c.Split('.')[1])
                        .Distinct()
                        .Select(relativePath => repositoryRootPath.Combine(relativePath))
                        .ToArray();
                }
                return activeExrepoPaths;
            }
            catch (RepositoryNotFoundException)
            {
                return Array.Empty<FilePath>();
            }
        }
    }
}
