﻿using System;
using System.Collections.Generic;
using System.Linq;

namespace SigloNact.BuiltIns.BuildSystem
{
    public class CopyFileAggregator : TargetRuleAggregator<string[], Tuple<string, string>, string>
    {
        public override Tuple<string, string> Translate(string[] input)
        {
            // Item1 がコピー元、Item2 がコピー先
            return Tuple.Create(input[0], input[1]);
        }

        public override string GetGroupKey(Tuple<string, string> data)
        {
            // コピー先ファイルのパスで Unique を取る
            return data.Item2;
        }

        public override void Validate(Tuple<string, string>[] group)
        {
            var sourcePaths = group.Select(x => x.Item1).Distinct();

            // コピー先が同じなのにコピー元が複数ある場合は Results の重複
            if (sourcePaths.Count() > 1)
            {
                throw new TargetRuleAggregatorException(string.Format(
                    "Tried to copy two distinct files to the same location.\n" +
                    "Source1     = {0}\n" +
                    "Source2     = {1}\n" +
                    "Destination = {2}",
                    sourcePaths.ElementAt(0), sourcePaths.ElementAt(1), group[0].Item2));
            }
        }

        public override object Translate(Tuple<string, string> output)
        {
            return new[] { output.Item1, output.Item2 };
        }
    }

    public class CopyDirectoryAggregator : CopyFileAggregator
    {
        // CopyFileAggregator を流用
    }
}
