﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Nintendo.Foundation.IO;
using VsSolutionLibrary;

namespace Nintendo.MakeSampleSolution
{
    class CommandLineOption
    {
        private string m_OutputDirectory;

        [CommandLineValue(
            0,
            Description = "Visual C++ プロジェクトファイル、またはソリューション設定ファイルのパスです。",
            IsRequired = true,
            ValueName = "inputfile")]
        public string InputFile { get; private set; }

        [CommandLineOption(
            "output-directory",
            Description = "ソリューションファイルの出力先ディレクトリです。無指定の場合は、入力ファイルと同じディレクトリとなります。",
            ValueName = "path")]
        public string OutputDirectory
        {
            get
            {
                if (m_OutputDirectory != null)
                {
                    return m_OutputDirectory;
                }
                else
                {
                    return Path.GetDirectoryName(InputFile);
                }
            }
            private set
            {
                m_OutputDirectory = value;
            }
        }

        [CommandLineOption(
            "vs-versions",
            Description = "生成するソリューションファイルのバージョンです。カンマで区切ることで複数指定可能です。",
            ValueName = "version")]
        public string VsVersionString { get; private set; }

        public static IEnumerable<VsSolutionVersion> ToVsSolutionVersions(string vsVersionString)
        {
            if (string.IsNullOrEmpty(vsVersionString))
            {
                return Enum.GetValues(typeof(VsSolutionVersion)).Cast<VsSolutionVersion>();
            }
            else
            {
                return vsVersionString
                    .Split(',')
                    .Select(x => x.ToLowerInvariant())
                    .Select(version =>
                    {
                        switch (version)
                        {
                            case "4.0":
                            case "2012":
                            case "vs2012":
                                return VsSolutionVersion.VisualStudio2012;
                            case "12.0":
                            case "2013":
                            case "vs2013":
                                return VsSolutionVersion.VisualStudio2013;
                            case "14.0":
                            case "2015":
                            case "vs2015":
                                return VsSolutionVersion.VisualStudio2015;
                            case "15.0":
                            case "2017":
                            case "vs2017":
                                return VsSolutionVersion.VisualStudio2017;
                            default:
                                throw new ArgumentException($"コマンドラインオプション値 '{version}' を有効な Visual Studio バージョンとして認識できません");
                        }
                    }).ToArray();
            }
        }
    }
}
