﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Nintendo.MakePropertySheets.Definition.StaticLibrary
{
    [System.ComponentModel.Composition.Export(typeof(IStaticLibraryDefinition))]
    class libnn_os : IStaticLibraryDefinition
    {
        public string Name => "libnn_os";

        public bool RequestsAddedToAdditionalDependencies(ReleaseIntent intent) => true;

        public string GetAdditionalDependenciesCondition(ReleaseIntent intent)
        {
            switch (intent.Spec)
            {
                case Constants.Spec.Cafe:
                    return string.Empty;
                default:
                    return Constants.Condition.PlatformWin32OrX64;
            }
        }
    }
}
