﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Nintendo.MakePropertySheets.Constructor.Property
{
    [System.ComponentModel.Composition.Export(typeof(ProjectElementConstructor))]
    class NintendoSdkAuthoringToolKeyIndex : ProjectElementConstructor
    {
        public override IEnumerable<ProjectElement> Construct(ConstructionContext ctx)
        {
            if (ctx.Intent.Spec != Constants.Spec.NX)
            {
                yield break;
            }
            if (!ctx.Intent.PublishSystemProgramSettings)
            {
                yield break;
            }

            switch (ctx.Intent.BuildEnvironment)
            {
                case Constants.BuildEnvironment.Repository:
                    yield return new ProjectProperty("NintendoSdkAuthoringToolKeyIndex", "2", "'$(NintendoSdkAuthoringToolKeyIndex)'==''");
                    break;
                case Constants.BuildEnvironment.Package:
                    // TORIAEZU: Ocean 専用の設定にしておく
                    yield return new ProjectProperty("NintendoSdkAuthoringToolKeyIndex", string.Empty, "'$(NintendoSdkAuthoringToolKeyIndex)'==''");
                    break;
                default:
                    ReportUnexpectedBuildEnvironment(ctx);
                    break;
            }
        }
    }
}
