﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Nintendo.MakePropertySheets.Constructor.Property
{
    [System.ComponentModel.Composition.Export(typeof(ProjectElementConstructor))]
    class NintendoSdkAuthoringToolKeyConfigFile : ProjectElementConstructor
    {
        public override IEnumerable<ProjectElement> Construct(ConstructionContext ctx)
        {
            if (ctx.Intent.Spec != Constants.Spec.NX)
            {
                yield break;
            }
            if (!ctx.Intent.PublishSystemProgramSettings)
            {
                yield break;
            }

            switch (ctx.Intent.BuildEnvironment)
            {
                case Constants.BuildEnvironment.Repository:
                    yield return new ProjectProperty(
                        "NintendoSdkAuthoringToolKeyConfigFile",
                        @"$(NintendoSdkRoot)Tools\CommandLineTools\AuthoringTool\AuthoringTool.repository.keyconfig.xml",
                        "'$(NintendoSdkAuthoringToolKeyConfigFile)'==''");
                    break;
                case Constants.BuildEnvironment.Package:
                    // TORIAEZU: Ocean 専用のパスにしておく
                    yield return new ProjectProperty(
                        "NintendoSdkAuthoringToolKeyConfigFile",
                        @"$(NintendoSdkRoot)Tools\CommandLineTools\AuthoringTool\AuthoringTool.ocean.keyconfig.xml",
                        "'$(NintendoSdkAuthoringToolKeyConfigFile)'==''");
                    break;
                default:
                    ReportUnexpectedBuildEnvironment(ctx);
                    break;
            }
        }
    }
}
