﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Nintendo.SigloBuild.Settings;

namespace Nintendo.MakePropertySheets.Constructor.Property
{
    [System.ComponentModel.Composition.Export(typeof(ProjectElementConstructor))]
    class NXToolchainVersion : ProjectElementConstructor
    {
        private static readonly string RyndaVersionPrefix = "clang-for-nx.";
        private readonly BuildSettings m_BuildSettings;

        public NXToolchainVersion()
        {
            this.m_BuildSettings = BuildSettings.Create();
        }

        public override IEnumerable<ProjectElement> Construct(ConstructionContext ctx)
        {
            if (ctx.Intent.Spec != Constants.Spec.NX)
            {
                yield break;
            }

            yield return new ProjectPropertyGroup(Constants.Condition.PlatformNX32OrNX64,
                new ProjectProperty("NXToolchainVersion", GetVersionNumber(m_BuildSettings.ToolChains.Rynda.Version)));
        }

        private static string GetVersionNumber(string ryndaVersionString)
        {
            if (ryndaVersionString.StartsWith(RyndaVersionPrefix))
            {
                return ryndaVersionString.Substring(RyndaVersionPrefix.Length);
            }
            else
            {
                throw new ImplementationErrorException($"Rynda version string has an unexpected format. : {ryndaVersionString}");
            }
        }
    }
}
