﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Nintendo.MakePropertySheets.Constructor.Property
{
    [System.ComponentModel.Composition.Export(typeof(ProjectElementConstructor))]
    class LibraryPath : ProjectElementConstructor
    {
        public override IEnumerable<ProjectElement> Construct(ConstructionContext ctx)
        {
            // TODO: Ocean が新方式のリンカオプション生成器を利用できる準備が整ったら削除
            if (ctx.Intent.Spec == Constants.Spec.NX && ctx.Intent.PublishSystemProgramSettings)
            {
                yield return new ProjectPropertyGroup(
                    $"{Constants.Condition.NintendoSdkProgramKindSystemProgramOrApplicationWithoutSdkNso} and '$(NintendoSdkUseUnifiedLinkCommandLineGenerator)'!='true'",
                    new ProjectProperty("LibraryPath", @"$(NXToolchainDir)\nx\armv7l\lib;$(LibraryPath)",
                        Constants.Condition.PlatformNX32),
                    new ProjectProperty("LibraryPath", @"$(NXToolchainDir)\nx\aarch64\lib;$(LibraryPath)",
                        Constants.Condition.PlatformNX64));
            }

            var libraryPaths = new List<string>();

            switch (ctx.Intent.Deliverable)
            {
                case Constants.Deliverable.SdkSample:
                    libraryPaths.Add(@"$(NintendoSdkRoot)Samples\Libraries\$(NintendoSdkBuildTarget)\$(NintendoSdkBuildType)");
                    break;
                case Constants.Deliverable.SdkTest:
                    libraryPaths.Add(@"$(NintendoSdkRoot)Tests\Libraries\$(NintendoSdkBuildTarget)\$(NintendoSdkBuildType)");
                    break;
                case Constants.Deliverable.Sdk:
                case Constants.Deliverable.Application:
                    // 不要
                    break;
                default:
                    ReportUnexpectedDeliverable(ctx);
                    break;
            }

            libraryPaths.Add("$(NintendoSdkLibraryPath)");

            libraryPaths.Add("$(LibraryPath)");
            yield return new ProjectProperty("LibraryPath", string.Join(";", libraryPaths));
        }
    }
}
