﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Nintendo.MakePropertySheets.Constructor.ItemDefinition.Link
{
    [System.ComponentModel.Composition.Export(typeof(ProjectElementConstructor))]
    class FinalizeMetaSource : ProjectElementConstructor
    {
        public override IEnumerable<ProjectElement> Construct(ConstructionContext ctx)
        {
            if (ctx.Intent.Spec != Constants.Spec.NX)
            {
                yield break;
            }

            if (ctx.Intent.Deliverable == Constants.Deliverable.SdkTest)
            {
                yield return new ProjectItemDefinition("Link", Constants.Condition.PlatformNX32OrNX64,
                    new ProjectMetadata("FinalizeMetaSource", @"$(NintendoSdkRoot)Tests\Common\Resources\TestApplication.arm.ilp32.nmeta", Constants.Condition.PlatformNX32),
                    new ProjectMetadata("FinalizeMetaSource", @"$(NintendoSdkRoot)Tests\Common\Resources\TestApplication.aarch64.lp64.nmeta", Constants.Condition.PlatformNX64));
            }
            else
            {
                yield return new ProjectItemDefinition("Link", Constants.Condition.PlatformNX32OrNX64,
                    new ProjectMetadata("FinalizeMetaSource", "$(NintendoSdkSpecFilesDirectory)Application.arm.ilp32.nmeta", Constants.Condition.PlatformNX32),
                    new ProjectMetadata("FinalizeMetaSource", "$(NintendoSdkSpecFilesDirectory)Application.aarch64.lp64.nmeta", Constants.Condition.PlatformNX64));
            }
        }
    }
}
