﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Nintendo.MakePropertySheets.Constructor.ItemDefinition.Link
{
    [System.ComponentModel.Composition.Export(typeof(ProjectElementConstructor))]
    class EnableDeadStrip : ProjectElementConstructor
    {
        public override IEnumerable<ProjectElement> Construct(ConstructionContext ctx)
        {
            if (ctx.Intent.Spec != Constants.Spec.NX)
            {
                yield break;
            }

            var metadatas = new List<ProjectMetadata>();

            switch (ctx.Intent.Deliverable)
            {
                case Constants.Deliverable.Sdk:
                case Constants.Deliverable.SdkSample:
                case Constants.Deliverable.SdkTest:
                    metadatas.Add(new ProjectMetadata("EnableDeadStrip", "false", Constants.Condition.ConfigurationTypeApplication));
                    break;
                case Constants.Deliverable.Application:
                    metadatas.Add(new ProjectMetadata("EnableDeadStrip", "true", Constants.Condition.ConfigurationTypeApplication));
                    if (ctx.Intent.PublishSystemProgramSettings)
                    {
                        metadatas.Add(new ProjectMetadata("EnableDeadStrip", "false",
                            $"{Constants.Condition.ConfigurationTypeApplication} and {Constants.Condition.NintendoSdkProgramKindSystemProgramOrApplicationWithoutSdkNso}"));
                    }
                    break;
                default:
                    ReportUnexpectedDeliverable(ctx);
                    break;
            }

            metadatas.Add(new ProjectMetadata("EnableDeadStrip", "false", Constants.Condition.ConfigurationTypeDynamicLibrary));

            yield return new ProjectItemDefinition("Link", Constants.Condition.PlatformNX32OrNX64, metadatas.ToArray());
        }
    }
}
