﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Nintendo.MakePropertySheets.Constructor.ItemDefinition.Link
{
    [System.ComponentModel.Composition.Export(typeof(ProjectElementConstructor))]
    class DebuggingLevel : ProjectElementConstructor
    {
        public override IEnumerable<ProjectElement> Construct(ConstructionContext ctx)
        {
            if (ctx.Intent.Spec != Constants.Spec.Cafe)
            {
                yield break;
            }

            yield return new ProjectItemDefinition("Link", Constants.Condition.PlatformCafe,
                new ProjectMetadata("DebuggingLevel", "MULTI", Constants.Condition.NintendoSdkBuildTypeDebug),
                new ProjectMetadata("DebuggingLevel", "None", Constants.Condition.NintendoSdkBuildTypeDevelopOrRelease));
        }
    }
}
