﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Nintendo.MakePropertySheets.Constructor.ItemDefinition.ClCompile
{
    [System.ComponentModel.Composition.Export(typeof(ProjectElementConstructor))]
    class PreprocessorDefinitions : ProjectElementConstructor
    {
        public override IEnumerable<ProjectElement> Construct(ConstructionContext ctx)
        {
            var itemDefinitions = new List<ProjectItemDefinition>();

            AddCommonPreprocessorDefinitions(ctx, itemDefinitions);
            AddWindowsVcPreprocessorDefinitions(ctx, itemDefinitions);

            switch (ctx.Intent.Spec)
            {
                case Constants.Spec.Generic:
                case Constants.Spec.NX:
                    // 不要
                    break;
                case Constants.Spec.Cafe:
                    AddCafePreprocessorDefinitions(ctx, itemDefinitions);
                    break;
                default:
                    ReportUnexpectedSpec(ctx);
                    break;
            }

            return itemDefinitions;
        }

        private void AddCommonPreprocessorDefinitions(ConstructionContext ctx, List<ProjectItemDefinition> itemDefinitions)
        {
            var metadatas = new List<ProjectMetadata>();

            metadatas.Add(new ProjectMetadata("PreprocessorDefinitions", "NN_NINTENDO_SDK;%(PreprocessorDefinitions)"));
            metadatas.Add(new ProjectMetadata("PreprocessorDefinitions", "NN_SDK_BUILD_DEBUG;%(PreprocessorDefinitions)", Constants.Condition.NintendoSdkBuildTypeDebug));
            metadatas.Add(new ProjectMetadata("PreprocessorDefinitions", "NN_SDK_BUILD_DEVELOP;%(PreprocessorDefinitions)", Constants.Condition.NintendoSdkBuildTypeDevelop));
            metadatas.Add(new ProjectMetadata("PreprocessorDefinitions", "NN_SDK_BUILD_RELEASE;%(PreprocessorDefinitions)", Constants.Condition.NintendoSdkBuildTypeRelease));

            if (ctx.Intent.Deliverable == Constants.Deliverable.Sdk)
            {
                metadatas.Add(new ProjectMetadata("PreprocessorDefinitions", "NN_SDK_BUILD_LIBRARY;%(PreprocessorDefinitions)", Constants.Condition.ConfigurationTypeStaticLibrary));
            }

            itemDefinitions.Add(new ProjectItemDefinition("ClCompile", metadatas.ToArray()));
        }

        private void AddWindowsVcPreprocessorDefinitions(ConstructionContext ctx, List<ProjectItemDefinition> itemDefinitions)
        {
            var metadatas = new List<ProjectMetadata>();

            metadatas.Add(new ProjectMetadata("PreprocessorDefinitions",
                "WIN32;_CRT_SECURE_NO_WARNINGS;_SCL_SECURE_NO_WARNINGS;%(PreprocessorDefinitions)"));

            // workaround for WindowsSDK bug
            metadatas.Add(new ProjectMetadata("PreprocessorDefinitions",
                "NTDDI_WIN7SP1=0x06010100;_WIN32_WINNT_WINTHRESHOLD=0x0A00;WINAPI_PARTITION_SYSTEM=0;%(PreprocessorDefinitions)"));

            metadatas.Add(new ProjectMetadata("PreprocessorDefinitions", "_DEBUG;%(PreprocessorDefinitions)", Constants.Condition.NintendoSdkBuildTypeDebug));
            metadatas.Add(new ProjectMetadata("PreprocessorDefinitions", "NDEBUG;%(PreprocessorDefinitions)", Constants.Condition.NintendoSdkBuildTypeDevelopOrRelease));

            if (ctx.Intent.Deliverable == Constants.Deliverable.Sdk|| ctx.Intent.Deliverable == Constants.Deliverable.SdkTest)
            {
                metadatas.Add(new ProjectMetadata("PreprocessorDefinitions", "WIN32_LEAN_AND_MEAN;NOMINMAX;%(PreprocessorDefinitions)"));
            }

            if (ctx.Intent.Deliverable == Constants.Deliverable.SdkSample || ctx.Intent.Deliverable == Constants.Deliverable.SdkTest)
            {
                metadatas.Add(new ProjectMetadata("PreprocessorDefinitions", "_CONSOLE;%(PreprocessorDefinitions)", Constants.Condition.ConfigurationTypeApplication));
            }

            itemDefinitions.Add(new ProjectItemDefinition("ClCompile", Constants.Condition.PlatformWin32OrX64, metadatas.ToArray()));
        }

        private void AddCafePreprocessorDefinitions(ConstructionContext ctx, List<ProjectItemDefinition> itemDefinitions)
        {
            var metadatas = new List<ProjectMetadata>();

            metadatas.Add(new ProjectMetadata("PreprocessorDefinitions", "NDEV=1;CAFE=2;PLATFORM=CAFE;EPPC;%(PreprocessorDefinitions)"));

            metadatas.Add(new ProjectMetadata("PreprocessorDefinitions", "_DEBUG;%(PreprocessorDefinitions)", Constants.Condition.NintendoSdkBuildTypeDebugOrDevelop));
            metadatas.Add(new ProjectMetadata("PreprocessorDefinitions", "NDEBUG;%(PreprocessorDefinitions)", Constants.Condition.NintendoSdkBuildTypeRelease));

            itemDefinitions.Add(new ProjectItemDefinition("ClCompile", Constants.Condition.PlatformCafe, metadatas.ToArray()));
        }
    }
}
