﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Nintendo.MakePropertySheets.Constructor.ItemDefinition.ClCompile
{
    [System.ComponentModel.Composition.Export(typeof(ProjectElementConstructor))]
    class AdditionalOptions : ProjectElementConstructor
    {
        public override IEnumerable<ProjectElement> Construct(ConstructionContext ctx)
        {
            switch (ctx.Intent.Spec)
            {
                case Constants.Spec.Generic:
                    return ConstructWindowsVcOptions(ctx);
                case Constants.Spec.NX:
                    return ConstructWindowsVcOptions(ctx).Concat(ConstructNXOptions(ctx));
                case Constants.Spec.Cafe:
                    return Enumerable.Empty<ProjectElement>();
                default:
                    ReportUnexpectedSpec(ctx);
                    return Enumerable.Empty<ProjectElement>();
            }
        }

        private IEnumerable<ProjectElement> ConstructWindowsVcOptions(ConstructionContext ctx)
        {
            // SDK の成果物についてのみ cl に /bigobj を付加する (SIGLO-62540)
            // VC++ 15.3 のバグ回避のため、 /permissive- の後に /Zc:twoPhase- を付加する。
            // 15.2 まで (14.10.25017) には /Zc:twoPhase オプションが存在しないことに注意。 (SIGLO-68962)
            switch (ctx.Intent.Deliverable)
            {
                case Constants.Deliverable.Sdk:
                case Constants.Deliverable.SdkSample:
                case Constants.Deliverable.SdkTest:
                    yield return new ProjectItemDefinition("ClCompile", $"{Constants.Condition.PlatformWin32OrX64} and {Constants.Condition.PlatformToolsetUseCl}",
                        new ProjectMetadata("AdditionalOptions", "/Zc:twoPhase- %(AdditionalOptions)", $"'$(PlatformToolset)'=='v141' and !$(VCToolsVersion.StartsWith('14.10.'))"));

                    yield return new ProjectItemDefinition("ClCompile", $"{Constants.Condition.PlatformWin32OrX64} and {Constants.Condition.PlatformToolsetUseCl}",
                        new ProjectMetadata("AdditionalOptions", "/w44668 /bigobj %(AdditionalOptions)", "'$(PlatformToolset)'!='v141'"));
                    yield return new ProjectItemDefinition("ClCompile", $"{Constants.Condition.PlatformWin32OrX64} and {Constants.Condition.PlatformToolsetUseCl}",
                        new ProjectMetadata("AdditionalOptions", "/permissive- /bigobj %(AdditionalOptions)", $"{Constants.Condition.PlatformWin32} and '$(PlatformToolset)'=='v141'"));
                    yield return new ProjectItemDefinition("ClCompile", $"{Constants.Condition.PlatformWin32OrX64} and {Constants.Condition.PlatformToolsetUseCl}",
                        new ProjectMetadata("AdditionalOptions", "/w44668 /permissive- /bigobj %(AdditionalOptions)", $"{Constants.Condition.PlatformX64} and '$(PlatformToolset)'=='v141'"));
                    break;
                case Constants.Deliverable.Application:
                    yield return new ProjectItemDefinition("ClCompile", $"{Constants.Condition.PlatformWin32OrX64} and {Constants.Condition.PlatformToolsetUseCl}",
                        new ProjectMetadata("AdditionalOptions", "/Zc:twoPhase- %(AdditionalOptions)", $"'$(PlatformToolset)'=='v141' and !$(VCToolsVersion.StartsWith('14.10.'))"));

                    yield return new ProjectItemDefinition("ClCompile", $"{Constants.Condition.PlatformWin32OrX64} and {Constants.Condition.PlatformToolsetUseCl}",
                        new ProjectMetadata("AdditionalOptions", "/w44668 %(AdditionalOptions)", "'$(PlatformToolset)'!='v141'"));
                    yield return new ProjectItemDefinition("ClCompile", $"{Constants.Condition.PlatformWin32OrX64} and {Constants.Condition.PlatformToolsetUseCl}",
                        new ProjectMetadata("AdditionalOptions", "/permissive- %(AdditionalOptions)", $"{Constants.Condition.PlatformWin32} and '$(PlatformToolset)'=='v141'"));
                    yield return new ProjectItemDefinition("ClCompile", $"{Constants.Condition.PlatformWin32OrX64} and {Constants.Condition.PlatformToolsetUseCl}",
                        new ProjectMetadata("AdditionalOptions", "/w44668 /permissive- %(AdditionalOptions)", $"{Constants.Condition.PlatformX64} and '$(PlatformToolset)'=='v141'"));
                    break;
                default:
                    ReportUnexpectedDeliverable(ctx);
                    break;
            }

            yield return new ProjectItemDefinition("ClCompile", $"{Constants.Condition.PlatformWin32OrX64} and {Constants.Condition.PlatformToolsetUseClang}",
                new ProjectMetadata("AdditionalOptions", "-Wstrict-aliasing -Werror=return-type -Wover-aligned %(AdditionalOptions)"));
        }

        private IEnumerable<ProjectElement> ConstructNXOptions(ConstructionContext ctx)
        {
            switch (ctx.Intent.Deliverable)
            {
                case Constants.Deliverable.Sdk:
                case Constants.Deliverable.SdkSample:
                case Constants.Deliverable.SdkTest:
                    yield return new ProjectItemDefinition("ClCompile", Constants.Condition.PlatformNX32OrNX64,
                        new ProjectMetadata("AdditionalOptions", "-Wstrict-aliasing -Werror=return-type -Wover-aligned %(AdditionalOptions)"));
                    break;
                case Constants.Deliverable.Application:
                    break;
                default:
                    ReportUnexpectedDeliverable(ctx);
                    break;
            }
        }
    }
}
