﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using GitExternalStorage.Transports;

namespace GitExternalStorage.Core
{
    public static class LocalCache
    {
        /// <summary>
        /// 各キャッシュファイルの状態を返します。
        /// </summary>
        /// <returns>キャッシュファイルの状態</returns>
        public static LocalCacheInfo FindLocalCaches(string cacheDirectoryPath, TransportBase transport)
        {
            var caches = new DirectoryInfo(cacheDirectoryPath).GetFiles().Select(x => x.Name);

            var unpushed = transport.GetUnpushed(caches);
            var pushed = caches.Except(unpushed);

            return new LocalCacheInfo()
            {
                Unpushed = unpushed.Select(x => new LocalCacheEntry() { Sha = x }).ToList(),
                Pushed = pushed.Select(x => new LocalCacheEntry() { Sha = x }).ToList()
            };
        }
    }
}
