﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using GitExternalStorage.Consoles;
using GitExternalStorage.Core;
using GitExternalStorage.Transports;

namespace GitExternalStorage.Commands
{
    /// <summary>
    /// キャッシュを外部ストレージにアップロードするコマンドです。
    /// </summary>
    public class UploadCommand : CommandBase
    {
        public UploadCommand()
            : base()
        {
        }

        public UploadCommand(CommandConsoleBase console)
            : base(console)
        {
        }

        public override void Run()
        {
            this.UploadLocalCache();
        }

        /// <summary>
        /// ローカルにあるキャッシュファイルを外部ストレージにアップロードします。
        /// </summary>
        private void UploadLocalCache()
        {
            CommandConsole.WriteLineToOut("Upload cache files.");

            var transport = Environments.Transport;
            var cacheInfo = LocalCache.FindLocalCaches(Environments.GetCacheDirectoryPath(), transport);
            foreach (var entry in cacheInfo.Unpushed)
            {
                CommandConsole.WriteLineToOut("uploading {0}", entry.Sha);

                try
                {
                    transport.Push(entry.Sha);
                }
                catch (TransportPathNotFoundException)
                {
                    CommandConsole.WriteLineToError("error: failed to find path : {0}", transport.GetPath());
                }
            }
        }
    }
}
