﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.IO;

namespace Bin2Cpp
{
    public class Program
    {
        public static void Main(string[] args)
        {
            var appParams = CommandLineParamsParser.Parse(args);
            if (appParams == null)
            {
                Environment.Exit(1);
            }

            using (var input = File.OpenRead(appParams.InputPath))
            {
                var data = new byte[input.Length];
                input.Read(data, 0, data.Length);

                var codeGenerator = new CodeGenerator(data, appParams.SymbolNameBegin, appParams.SymbolNameEnd, appParams.NameSpace, appParams.Const, appParams.Align);

                Directory.CreateDirectory(Directory.GetParent(appParams.OutputHeaderPath).FullName);
                using (var file = File.Create(appParams.OutputHeaderPath))
                using (var writer = new StreamWriter(file, Encoding.GetEncoding("utf-8")))
                {
                    writer.Write(codeGenerator.GetHeader());
                }

                Directory.CreateDirectory(Directory.GetParent(appParams.OutputCppPath).FullName);
                using (var file = File.Create(appParams.OutputCppPath))
                using (var writer = new StreamWriter(file, Encoding.GetEncoding("utf-8")))
                {
                    writer.Write(codeGenerator.GetCpp());
                }
            }
        }
    }
}
