﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <cmath>
#include <nn/cstd/cstd_CMath.h>

namespace nn { namespace cstd {

bool IsNan(long double value) NN_NOEXCEPT
{
    return std::isnan(value);
}

bool IsNan(double value) NN_NOEXCEPT
{
    return std::isnan(value);
}

bool IsNan(float value) NN_NOEXCEPT
{
    return std::isnan(value);
}

bool IsInf(long double value) NN_NOEXCEPT
{
    return std::isinf(value);
}

bool IsInf(double value) NN_NOEXCEPT
{
    return std::isinf(value);
}

bool IsInf(float value) NN_NOEXCEPT
{
    return std::isinf(value);
}

}}
