﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <cstdint>
#include <nn/crypto/detail/crypto_BigNum.h>
#include "crypto_EccP256Math.h"

namespace nn { namespace crypto { namespace detail {

/* ECC P-256 */
typedef struct
{
    BigNum::Digit r[ECC_P256_BIGINT_DIGITS];
    BigNum::Digit s[ECC_P256_BIGINT_DIGITS];
} p256_ec_signature;

typedef struct
{
    BigNum::Digit private_key[ECC_P256_BIGINT_DIGITS];
    p256_point public_key;
} p256_ec_keypair;

typedef enum
{
    CSL_OK = 0,
    CSL_OVERFLOW,
    CSL_DIVIDE_BY_ZERO,
    CSL_SHA_ERROR,
    CSL_AES_ERROR,
    CSL_BAD_KEY,
    CSL_NULL_POINTER,
    CSL_VERIFY_ERROR
} CSL_error;

CSL_error alg_p256_ECDSA_sign(p256_ec_signature* signature,
                              const void* messageDigest, size_t messageDigestSize,
                              const p256_ec_parameter* public_curve,
                              const BigNum::Digit* private_key,
                              const BigNum::Digit* rand_input, size_t rand_digits);

CSL_error alg_p256_ECDSA_verify(const p256_ec_signature* signature,
                                const void* messageDigest, size_t messageDigestSize,
                                const p256_ec_parameter* public_curve,
                                const p256_point* signer_point);

CSL_error alg_p256_generate_shared_key(BigNum::Digit* shared_secret,
                                       const p256_point* base_point, const p256_curve* E,
                                       const p256_point* recipient_public,
                                       const BigNum::Digit* my_private );

/*
CSL_error alg_p256_generate_private_key(const BigNum::Digit* rand_input, int rand_digits,
                                        const p256_ec_parameter* public_curve,
                                        BigNum::Digit* my_private);

CSL_error alg_p256_generate_public_key(p256_point* base_point, p256_curve* E,
                                       BigNum::Digit* my_private, p256_point* my_public);

CSL_error alg_p256_generate_shared_key_pre(p256_point* base_point, p256_curve* E,
                                           p256_point* recipient_public, BigNum::Digit* my_private,
                                           BigNum::Digit* shared_secret);
*/

}}} // namespace nn::crypto::detail
