﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/crypto/crypto_Md5Generator.h>

namespace nn { namespace crypto {

const uint8_t Md5Generator::Asn1ObjectIdentifier[Asn1ObjectIdentifierSize] = {
    0x30, 0x20, 0x30, 0x0c, 0x06, 0x08, 0x2a, 0x86, 0x48, 0x86, 0xf7, 0x0d, 0x02, 0x05, 0x05, 0x00, 0x04, 0x10
};

void GenerateMd5Hash(void* pHash, size_t hashSize, const void* pData, size_t dataSize) NN_NOEXCEPT
{
    Md5Generator md5;

    md5.Initialize();
    md5.Update(pData, dataSize);
    md5.GetHash(pHash, hashSize);
}

}} // namespace nn::crypto
