﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/crypto/crypto_HmacSha1Generator.h>

namespace nn { namespace crypto {

void GenerateHmacSha1Mac(void* pMac, size_t macSize,
                         const void* pData, size_t dataSize,
                         const void* pKey, size_t keySize) NN_NOEXCEPT
{
    HmacSha1Generator hmacSha1;

    hmacSha1.Initialize(pKey, keySize);
    hmacSha1.Update(pData, dataSize);
    hmacSha1.GetMac(pMac, macSize);
}

}}
